package nemosofts.voxradio.adapter.home;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentTransaction;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.material.EnchantedViewPager;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.MainActivity;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.activity.PodcastsByActivity;
import nemosofts.voxradio.activity.RadioByActivity;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.fragment.online.FragmentCategories;
import nemosofts.voxradio.fragment.online.FragmentCountries;
import nemosofts.voxradio.fragment.online.FragmentLatest;
import nemosofts.voxradio.fragment.online.FragmentPodcasts;
import nemosofts.voxradio.fragment.online.FragmentRecent;
import nemosofts.voxradio.fragment.online.FragmentSectionRadio;
import nemosofts.voxradio.fragment.online.FragmentTrending;
import nemosofts.voxradio.interfaces.InterAdListener;
import nemosofts.voxradio.interfaces.RewardAdListener;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.helper.SPHelper;
import nemosofts.voxradio.utils.recycler.RecyclerItemClickListener;

@UnstableApi
public class AdapterHome extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    Context context;
    Helper helper;
    SPHelper spHelper;
    List<ItemPost> arrayList;
    int clickPos = 0;

    private static final String TAG_CREDIT = "Your Total Credit (";
    private static final String TAG_HOME = "home-";
    private static final String TAG_IS_HOME = "ishome";

    private static final int VIEW_PROG = 0;
    private static final int VIEW_BANNER = 1;
    private static final int VIEW_CATEGORIES = 2;
    private static final int VIEW_COUNTRIES = 3;
    private static final int VIEW_PODCASTS = 4;
    private static final int VIEW_RADIO = 5;
    private static final int VIEW_RECENT = 6;
    private static final int VIEW_TRENDING = 7;
    private static final int VIEW_LATEST = 8;
    private static final int VIEW_ADS = 9;

    Boolean ads = true;

    AdapterHomeTrending adapterHomeTrending;
    AdapterHomeTrending adapterHomeLatest;
    AdapterHomeRecent adapterHomeRecent;

    public AdapterHome(Context context, List<ItemPost> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
        helper = new Helper(context, interAdListener);
        spHelper = new SPHelper(context);
    }

    public static class BannerHolder extends RecyclerView.ViewHolder {

        EnchantedViewPager enchantedViewPager;
        HomePagerAdapter homePagerAdapter;

        BannerHolder(View view) {
            super(view);
            enchantedViewPager = view.findViewById(R.id.viewPager_home);
            enchantedViewPager.useAlpha();
            enchantedViewPager.useScale();
            enchantedViewPager.setPageMargin(-5);
        }
    }

    public class CategoriesHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        AdapterHomeCategories adapterHomeCategories;
        TextView title;
        LinearLayout viewAll;

        CategoriesHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager manager = new LinearLayoutManager(
                    context, LinearLayoutManager.HORIZONTAL, false
            );
            rv.setLayoutManager(manager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class CountriesHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        AdapterHomeCountries adapterHomeCountries;
        TextView title;
        LinearLayout viewAll;

        CountriesHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager manager = new LinearLayoutManager(
                    context, LinearLayoutManager.HORIZONTAL, false
            );
            rv.setLayoutManager(manager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class PodcastsHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        AdapterHomePodcasts adapterHomePodcasts;
        TextView title;
        LinearLayout viewAll;

        PodcastsHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager manager = new LinearLayoutManager(
                    context, LinearLayoutManager.HORIZONTAL, false
            );
            rv.setLayoutManager(manager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class RecentHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        TextView title;
        LinearLayout viewAll;

        RecentHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager manager = new LinearLayoutManager(
                    context, LinearLayoutManager.HORIZONTAL, false
            );
            rv.setLayoutManager(manager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class RadiosHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        TextView title;
        AdapterHomeRadio adapterHomeRadio;
        LinearLayout viewAll;

        RadiosHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager manager = new LinearLayoutManager(
                    context, LinearLayoutManager.HORIZONTAL, false
            );
            rv.setLayoutManager(manager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class TrendingHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        TextView title;
        LinearLayout viewAll;

        TrendingHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager manager = new LinearLayoutManager(
                    context, LinearLayoutManager.HORIZONTAL, false
            );
            rv.setLayoutManager(manager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class LatestHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        TextView title;
        LinearLayout viewAll;

        LatestHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager manager = new LinearLayoutManager(
                    context, LinearLayoutManager.HORIZONTAL, false
            );
            rv.setLayoutManager(manager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public static class LatestAds extends RecyclerView.ViewHolder {

        LinearLayout adView;

        LatestAds(View view) {
            super(view);
            adView = view.findViewById(R.id.ll_adView);
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {

        @SuppressLint("StaticFieldLeak")
        private static ProgressBar progressBar;

        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_BANNER) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_banner, parent, false);
            return new BannerHolder(itemView);
        } else if (viewType == VIEW_CATEGORIES) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CategoriesHolder(itemView);
        } else if (viewType == VIEW_COUNTRIES) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CountriesHolder(itemView);
        } else if (viewType == VIEW_PODCASTS) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new PodcastsHolder(itemView);
        } else if (viewType == VIEW_RECENT) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new RecentHolder(itemView);
        } else if (viewType == VIEW_RADIO) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new RadiosHolder(itemView);
        } else if (viewType == VIEW_TRENDING) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new TrendingHolder(itemView);
        } else if (viewType == VIEW_LATEST) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new LatestHolder(itemView);
        } else if (viewType == VIEW_ADS) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_baner_ad, parent, false);
            return new LatestAds(itemView);
        } else {
            View v = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_progressbar, parent, false);
            return new ProgressViewHolder(v);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof BannerHolder bannerHolder) {
            if (bannerHolder.homePagerAdapter == null) {
                bannerHolder.enchantedViewPager.setFocusable(false);
                bannerHolder.homePagerAdapter = new HomePagerAdapter(context,
                        arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListBanner()
                );
                bannerHolder.enchantedViewPager.setAdapter(bannerHolder.homePagerAdapter);
                if (bannerHolder.homePagerAdapter.getCount() > 2) {
                    bannerHolder.enchantedViewPager.setCurrentItem(1);
                }
            }
        }
        else if (holder instanceof CategoriesHolder categoriesHolder) {

            categoriesHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            categoriesHolder.adapterHomeCategories = new AdapterHomeCategories(
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListCategories()
            );
            categoriesHolder.rv.setAdapter(categoriesHolder.adapterHomeCategories);
            categoriesHolder.rv.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAbsoluteAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.categories));
            }));

            categoriesHolder.viewAll.setOnClickListener(v -> {
                FragmentCategories albums = new FragmentCategories();
                int bottomMenu;
                String titlePage;
                if (Boolean.TRUE.equals(arrayList.get(holder.getAbsoluteAdapterPosition()).getIsSections())){
                    Bundle bundle = new Bundle();
                    bundle.putBoolean(TAG_IS_HOME, true);
                    bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                    albums.setArguments(bundle);
                    bottomMenu = 5;
                    titlePage = arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                } else {
                    bottomMenu = 3;
                    titlePage = context.getString(R.string.categories);
                }
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, albums, context.getString(R.string.categories));
                ft.addToBackStack(context.getString(R.string.categories));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(titlePage);
                ((MainActivity) context).bottomNavigationView(bottomMenu);
            });
        }
        else if (holder instanceof CountriesHolder countriesHolder) {

            countriesHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            countriesHolder.adapterHomeCountries = new AdapterHomeCountries(
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListCountries()
            );
            countriesHolder.rv.setAdapter(countriesHolder.adapterHomeCountries);
            countriesHolder.rv.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAbsoluteAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.countries));
            }));

            countriesHolder.viewAll.setOnClickListener(v -> {
                FragmentCountries countries = new FragmentCountries();
                Bundle bundle = new Bundle();
                bundle.putBoolean(TAG_IS_HOME, true);
                bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                countries.setArguments(bundle);
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, countries, context.getString(R.string.countries));
                ft.addToBackStack(context.getString(R.string.countries));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(
                        arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle()
                );
                ((MainActivity) context).bottomNavigationView(5);
            });

        }
        else if (holder instanceof PodcastsHolder podcastsHolder) {

            podcastsHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            podcastsHolder.adapterHomePodcasts = new AdapterHomePodcasts(
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListPodcasts()
            );
            podcastsHolder.rv.setAdapter(podcastsHolder.adapterHomePodcasts);
            podcastsHolder.rv.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAbsoluteAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.podcasts));
            }));

            podcastsHolder.viewAll.setOnClickListener(v -> {
                FragmentPodcasts podcasts = new FragmentPodcasts();
                Bundle bundle = new Bundle();
                bundle.putBoolean(TAG_IS_HOME, true);
                bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                podcasts.setArguments(bundle);
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, podcasts, context.getString(R.string.podcasts));
                ft.addToBackStack(context.getString(R.string.podcasts));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(
                        arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle()
                );
                ((MainActivity) context).bottomNavigationView(5);
            });

        }
        else if (holder instanceof RadiosHolder radiosHolder) {

            radiosHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            radiosHolder.adapterHomeRadio = new AdapterHomeRadio(context,
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio(), new AdapterHomeRadio.RecyclerItemClickListener() {
                @Override
                public void onClick(int position) {
                    if (NetworkUtils.isConnected(context)) {
                        String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                        addData(addedFrom, position, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                        helper.showInterAd(position, context.getString(R.string.radio));
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onRewardAds(int position) {
                    if (spHelper.getRewardCredit() != 0){
                        spHelper.useRewardCredit(1);
                        if (NetworkUtils.isConnected(context)) {
                            String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                            addData(addedFrom, position, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                            helper.showInterAd(position, context.getString(R.string.radio));
                            Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        helper.showRewardAds(position, new RewardAdListener() {
                            @Override
                            public void onClick(boolean isLoad, int pos) {
                                if (isLoad){
                                    spHelper.addRewardCredit(Callback.getRewardCredit());
                                    spHelper.useRewardCredit(1);
                                    if (NetworkUtils.isConnected(context)) {
                                        String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                                        addData(addedFrom, pos, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                                        helper.showInterAd(pos, context.getString(R.string.radio));
                                        Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                    } else {
                                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                    }
                                } else {
                                    Toast.makeText(context, "Display Failed adapterHomeRadio", Toast.LENGTH_SHORT).show();
                                }
                            }

                            @Override
                            public void onPurchases(int pos) {
                                if (NetworkUtils.isConnected(context)) {
                                    String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                                    addData(addedFrom, pos, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                                    helper.showInterAd(pos, context.getString(R.string.radio));
                                    Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                } else {
                                    Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                }
                            }
                        });
                    }
                }
            });
            radiosHolder.rv.setAdapter(radiosHolder.adapterHomeRadio);

            radiosHolder.viewAll.setOnClickListener(v -> {
                FragmentSectionRadio section = new FragmentSectionRadio();
                Bundle bundle = new Bundle();
                bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                section.setArguments(bundle);
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, section, context.getString(R.string.radio));
                ft.addToBackStack(context.getString(R.string.radio));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(radiosHolder.title.getText().toString());
                ((MainActivity) context).bottomNavigationView(5);
            });
        }
        else if (holder instanceof TrendingHolder trendingHolder) {
            trendingHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            adapterHomeTrending = new AdapterHomeTrending(context,
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListTrending(), true,
                    new AdapterHomeTrending.RecyclerItemClickListener() {
                @Override
                public void onClick(int position) {
                    if (NetworkUtils.isConnected(context)) {
                        String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                        addData(addedFrom, position, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListTrending());
                        helper.showInterAd(position, context.getString(R.string.radio));
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onRewardAds(int position) {
                    if (spHelper.getRewardCredit() != 0){
                        spHelper.useRewardCredit(1);
                        if (NetworkUtils.isConnected(context)) {
                            String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                            addData(addedFrom, position, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListTrending());
                            helper.showInterAd(position, context.getString(R.string.radio));
                            Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        helper.showRewardAds(position, new RewardAdListener() {
                            @Override
                            public void onClick(boolean isLoad, int pos) {
                                if (isLoad){
                                    spHelper.addRewardCredit(Callback.getRewardCredit());
                                    spHelper.useRewardCredit(1);
                                    if (NetworkUtils.isConnected(context)) {
                                        String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                                        addData(addedFrom, pos, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListTrending());
                                        helper.showInterAd(pos, context.getString(R.string.radio));
                                        Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                    } else {
                                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                    }
                                } else {
                                    Toast.makeText(context, "Display Failed", Toast.LENGTH_SHORT).show();
                                }
                            }

                            @Override
                            public void onPurchases(int pos) {
                                if (NetworkUtils.isConnected(context)) {
                                    String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                                    addData(addedFrom, pos, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListTrending());
                                    helper.showInterAd(pos, context.getString(R.string.radio));
                                    Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                } else {
                                    Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                }
                            }
                        });
                    }
                }
            });
            trendingHolder.rv.setAdapter(adapterHomeTrending);

            trendingHolder.viewAll.setOnClickListener(v -> {
                FragmentTrending most = new FragmentTrending();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, most, context.getString(R.string.trending));
                ft.addToBackStack(context.getString(R.string.trending));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.trending));
                ((MainActivity) context).bottomNavigationView(2);
            });
        }
        else if (holder instanceof LatestHolder latestHolder) {
            latestHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            adapterHomeLatest = new AdapterHomeTrending(context,
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio(), false,
                    new AdapterHomeTrending.RecyclerItemClickListener() {
                @Override
                public void onClick(int position) {
                    if (NetworkUtils.isConnected(context)) {
                        String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                        addData(addedFrom, position, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                        helper.showInterAd(position, context.getString(R.string.radio));
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onRewardAds(int position) {
                    if (spHelper.getRewardCredit() != 0){
                        spHelper.useRewardCredit(1);
                        if (NetworkUtils.isConnected(context)) {
                            String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                            addData(addedFrom, position, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                            helper.showInterAd(position, context.getString(R.string.radio));
                            Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        helper.showRewardAds(position, new RewardAdListener() {
                            @Override
                            public void onClick(boolean isLoad, int pos) {
                                if (isLoad){
                                    spHelper.addRewardCredit(Callback.getRewardCredit());
                                    spHelper.useRewardCredit(1);
                                    if (NetworkUtils.isConnected(context)) {
                                        String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                                        addData(addedFrom, pos, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                                        helper.showInterAd(pos, context.getString(R.string.radio));
                                        Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                    } else {
                                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                    }
                                } else {
                                    Toast.makeText(context, "Display Failed", Toast.LENGTH_SHORT).show();
                                }
                            }

                            @Override
                            public void onPurchases(int pos) {
                                if (NetworkUtils.isConnected(context)) {
                                    String addedFrom = TAG_HOME + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                                    addData(addedFrom, pos, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                                    helper.showInterAd(pos, context.getString(R.string.radio));
                                    Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                } else {
                                    Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                }
                            }
                        });
                    }
                }
            });
            latestHolder.rv.setAdapter(adapterHomeLatest);

            latestHolder.viewAll.setOnClickListener(v -> {
                FragmentLatest latest = new FragmentLatest();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, latest, context.getString(R.string.latest));
                ft.addToBackStack(context.getString(R.string.latest));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.latest));
                ((MainActivity) context).bottomNavigationView(1);
            });
        }
        else if (holder instanceof RecentHolder recentHolder) {
            recentHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            adapterHomeRecent = new AdapterHomeRecent(context,arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRecently());
            recentHolder.rv.setAdapter(adapterHomeRecent);

            recentHolder.rv.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position12) -> {
                if (NetworkUtils.isConnected(context)) {
                    String addedFrom = "homeRecent-" + arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle();
                    addData(addedFrom, position12, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRecently());
                    helper.showInterAd(position12, context.getString(R.string.radio));
                } else {
                    Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                }
            }));

            recentHolder.viewAll.setOnClickListener(v -> {
                FragmentRecent recent = new FragmentRecent();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, recent, context.getString(R.string.recently));
                ft.addToBackStack(context.getString(R.string.recently));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.recently));
                ((MainActivity) context).bottomNavigationView(4);
            });
        }
        else if (holder instanceof LatestAds latestAds && Boolean.TRUE.equals(ads)){
            ads = false;
            helper.showBannerAd(latestAds.adView, Callback.PAGE_HOME);
        }
    }

    private void addData(String addedFrom, int position, List<ItemRadio> arrayListRadio) {
        Callback.setIsRadio(true);
        if (!Callback.getAddedFrom().equals(addedFrom)) {
            Callback.getArrayListPlay().clear();
            Callback.setArrayListPlay(arrayListRadio);
            Callback.setAddedFrom(addedFrom);
            Callback.setIsNewAdded(true);
        }
        Callback.setPlayPos(position);
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public void hideHeader() {
        ProgressViewHolder.progressBar.setVisibility(View.GONE);
    }

    public boolean isHeader(int position) {
        return arrayList.get(position) == null;
    }

    @SuppressLint("NotifyDataSetChanged")
    public void onEqualizerChange() {
        try {
            if (adapterHomeTrending != null){
                adapterHomeTrending.notifyDataSetChanged();
            }
            if (adapterHomeLatest != null){
                adapterHomeLatest.notifyDataSetChanged();
            }
            if (adapterHomeRecent != null){
                adapterHomeRecent.notifyDataSetChanged();
            }
        } catch (Exception e) {
            Log.e("AdapterHomeTrending" ,"Error onEqualizerChange", e);
        }
    }

    @Override
    public int getItemViewType(int position) {
        String type = arrayList.get(position).getType();
        int viewType;
        switch (type) {
            case "radio" -> viewType = VIEW_RADIO;
            case "latest" -> viewType = VIEW_LATEST;
            case "trending" -> viewType = VIEW_TRENDING;
            case "recent" -> viewType = VIEW_RECENT;
            case "countries" -> viewType = VIEW_COUNTRIES;
            case "podcasts" -> viewType = VIEW_PODCASTS;
            case "category" -> viewType = VIEW_CATEGORIES;
            case "slider" -> viewType = VIEW_BANNER;
            case "ads" -> viewType = VIEW_ADS;
            default -> viewType = VIEW_PROG;
        }
        return viewType;
    }

    InterAdListener interAdListener = (position, type) -> {
        if (type.equals(context.getString(R.string.radio))) {
            Intent intent = new Intent(context, PlayerService.class);
            intent.setAction(PlayerService.ACTION_PLAY);
            context.startService(intent);
        } else if (type.equals(context.getString(R.string.categories))) {
            Intent intent = new Intent(context, RadioByActivity.class);
            intent.putExtra("type", context.getString(R.string.categories));
            intent.putExtra("id", arrayList.get(clickPos).getArrayListCategories().get(position).id());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListCategories().get(position).name());
            context.startActivity(intent);
        } else if (type.equals(context.getString(R.string.countries))) {
            Intent intent = new Intent(context, RadioByActivity.class);
            intent.putExtra("type", context.getString(R.string.countries));
            intent.putExtra("id", arrayList.get(clickPos).getArrayListCountries().get(position).id());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListCountries().get(position).name());
            context.startActivity(intent);
        } else if (type.equals(context.getString(R.string.podcasts))) {
            Intent intent = new Intent(context, PodcastsByActivity.class);
            intent.putExtra("id", arrayList.get(clickPos).getArrayListPodcasts().get(position).id());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListPodcasts().get(position).name());
            context.startActivity(intent);
        }
    };
}